<?php
if ( !defined( 'COLLABORATIVE_FILTERING_PLUGIN' ) )
	exit;
?>
<script>
	var cf_obj = cf_obj || {};
	cf_obj.param = function ( a ) {
		var s = [];
		var add = function (key, value) {
			s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value == null ? "" : value);
		};

		if (Array.isArray(a)) {
			cf_obj.each(a, function () {
				add(this.name, this.value);
			});
		} else {
			for (var prefix in a) {
				cf_obj.buildParams(prefix, a[prefix], add);
			}
		}
		return s.join('&');
	};
	cf_obj.buildParams = function (prefix, obj, add) {
		if (Array.isArray(obj)) {
			cf_obj.each(obj, function (i, v) {
				cf_obj.buildParams(prefix + "[" + ( typeof v === "object" && v != null ? i : "" ) + "]", v, add);
			});
		} else if ("object" === typeof obj) {
			for (var name in obj) {
				cf_obj.buildParams(prefix + "[" + name + "]", obj[name], add);
			}
		} else {
			add(prefix, obj);
		}
	};
	cf_obj.each = function( obj, fn ) {
		if (obj.length == undefined)
			for (var i in obj)
				fn.call(obj[i], i, obj[i]);
		else
			for (var i = 0, ol = obj.length, val = obj[0];
				 i < ol && fn.call(val, i, val) !== false; val = obj[++i]) {
			}
		return obj;
	};
	cf_obj.ajax = function( d, method, done, fail, always ) {
		var xhr = window.ActiveXObject ? new ActiveXObject("Microsoft.XMLHTTP") : new XMLHttpRequest();
		var url = cf_obj.ajaxurl;

		if (d && typeof d != "string")
			d = cf_obj.param(d);

		if (method.toLowerCase() == "get") {
			url += (url.match(/\?/) ? "&" : "?") + "_=" + (new Date()).getTime();

			if (d) {
				url += "&" + d;
				d = null;
			}
		}

		xhr.open(method, url, true);
		xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		xhr.onreadystatechange = function () {
			if (4 === xhr.readyState) {
				if (200 === xhr.status) {
					try {
						var json = JSON.parse(xhr.responseText);
						if (done) done(json);
					} catch (e) {
						if (fail) fail(e.message);
					}
				} else {
					if (fail) fail(xhr.error);
				}
				if (always) always();
			}
		};
		xhr.send(d);
		return xhr;
	};
</script>
